/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_TRIB]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PROD_AGENDA_COMPRA_PRODUTOS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PROD_AGENDA_COMPRA_PRODUTOS]
GO 

CREATE FUNCTION UFD_EST_PROD_AGENDA_COMPRA_PRODUTOS (@CD_EMP TINYINT=1, @CD_AGENDA INT ) 
 							
RETURNS @TMP_PROD TABLE(CD_EMP                            TINYINT,
                            CD_PROD                           INT)
AS
BEGIN
/***********************************************************************************************/
-- Carga dos produtos que participam da agenda.
/***********************************************************************************************/
 
DECLARE @TMP_PROD_AUX AS TABLE  (CD_EMP TINYINT,CD_PROD INT);
	
	INSERT INTO @TMP_PROD 
	SELECT 
		P.CD_EMP,		
		P.CD_PROD
	FROM 
		EST_PROD_AGENDA_COMPRA_EST_PROD p
	WHERE
		P.CD_EMP = @CD_EMP
		AND p.CD_CTR_AGENDA = @CD_AGENDA ;  
	
	if exists(select top 1 1 from @TMP_PROD )
		GOTO FimCargaProdutos
		 
	--Fabricantes
	INSERT INTO @TMP_PROD 
	SELECT 
		F.CD_EMP, 
		P.CD_PROD
	FROM 
		EST_PROD_AGENDA_COMPRA_EST_PROD_FABRIC F
		JOIN EST_PROD P ON 
		F.CD_EMP = P.CD_EMP AND
		F.CD_FABRIC = P.CD_FABRIC
	WHERE
		P.CD_EMP = @CD_EMP
		AND F.CD_CTR_AGENDA = @CD_AGENDA ; 
	
	--select top 5* from #TMP_PROD
	--Linhas
	if exists(select top 1 1 from @TMP_PROD )
	begin		
		INSERT INTO @TMP_PROD_AUX 
		SELECT 
			L.CD_EMP,
			A.CD_PROD 
		FROM 
			EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_LINHA L
			JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
			L.CD_EMP = A.CD_EMP AND
			L.CD_ARV_MERC_LINHA= A.CD_ARV_MERC_LINHA 
			JOIN @TMP_PROD T ON 
			A.CD_EMP  = T.CD_EMP AND
			A.CD_PROD = T.CD_PROD			
		WHERE
			L.CD_CTR_AGENDA = @CD_AGENDA ;

		if @@rowcount>0
		begin
			DELETE @TMP_PROD;

			INSERT INTO @TMP_PROD 
			SELECT CD_EMP, CD_PROD FROM @TMP_PROD_AUX;
			DELETE @TMP_PROD_AUX;
		end
	end
	ELSE
	BEGIN
		INSERT INTO @TMP_PROD
		SELECT 
			L.CD_EMP,
			A.CD_PROD 
		FROM 
			EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_LINHA L
			JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
			L.CD_EMP = A.CD_EMP AND
			L.CD_ARV_MERC_LINHA= A.CD_ARV_MERC_LINHA  
		WHERE
			L.CD_CTR_AGENDA = @CD_AGENDA ;
	END
	 
	--Categorias 
	if exists(select top 1 1 from @TMP_PROD )
	begin		
		INSERT INTO @TMP_PROD_AUX 
		SELECT 
			C.CD_EMP,		
			A.CD_PROD 
		FROM 
			EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_CATEGORIA C
			JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
			C.CD_EMP = A.CD_EMP AND
			C.CD_ARV_MERC_CATEG= A.CD_ARV_MERC_CATEG 
			JOIN @TMP_PROD T ON 
			A.CD_EMP  = T.CD_EMP AND
			A.CD_PROD = T.CD_PROD	
		WHERE
			A.CD_EMP = @CD_EMP
			AND C.CD_CTR_AGENDA = @CD_AGENDA ;  
			
		if @@rowcount>0
		begin
			DELETE @TMP_PROD 
			INSERT INTO @TMP_PROD 
			SELECT CD_EMP, CD_PROD FROM @TMP_PROD_AUX;
			DELETE @TMP_PROD_AUX
		end
	END
	ELSE
	BEGIN
		INSERT INTO @TMP_PROD 
		SELECT 
			C.CD_EMP,		
			A.CD_PROD 
		FROM 
			EST_PROD_AGENDA_COMPRA_EST_ARV_MERC_CATEGORIA C
			JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
			C.CD_EMP = A.CD_EMP AND
			C.CD_ARV_MERC_CATEG= A.CD_ARV_MERC_CATEG 
		WHERE
			A.CD_EMP = @CD_EMP
			AND C.CD_CTR_AGENDA = @CD_AGENDA ; 
	END
	  
FimCargaProdutos:  
		Return; 

END